/* 
 *  GetSessionDataRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.JavaFXRefClient;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.SessionData;

import javafx.concurrent.WorkerStateEvent;

public class GetSessionDataRequest extends SessionRequest {

    private static final Logger LOG = Logger.getLogger(GetSessionDataRequest.class);
    private final JavaFXRefClient gui;

    public GetSessionDataRequest(JavaFXRefClient gui) {
        super(LOG);
        this.gui = gui;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        SessionData data;
        if (getSession() != null) {
            LOG.trace(methodName + "session non null");
            data = new SessionData(getSession());
        } else {
            LOG.trace(methodName + "session null, returning blank data");
            data = new SessionData(null);
        }
        LOG.trace(methodName + "-");
        return data;
    }

    @Override
    public void setSucceeded() {
        this.setOnSucceeded((WorkerStateEvent t) -> {
            String methodName = "succeededHandler() ";
            SessionData value = (SessionData) t.getSource().valueProperty().getValue();
            if (value != null) {
                LOG.debug(methodName + "SessionData:" + value);
                gui.updateSessionData(value);
            } else {
                LOG.debug(methodName + " NULL");
            }
        });
    }
}
